CREATE PROCEDURE [dbo].[LX_B2C_GERA_TROCA] @ID_OCORRENCIA INT, @ID_TIPO_DEVOLUCAO INT
AS
BEGIN
      SET NOCOUNT ON
      
      DECLARE @NOVO_PEDIDO INT, @DATA_ATUAL DATETIME, @COD_FORMA_PGTO CHAR(2), @CODIGO_FILIAL_ORIGEM CHAR(6), @COUNT_OCORRENCIA AS INT,
      @ITEM INT
      
	  SELECT 
		@COUNT_OCORRENCIA = ISNULL(COUNT(*), 0)
	  FROM 
		B2C_OCORRENCIA

	  IF @COUNT_OCORRENCIA = 0
	  BEGIN
		SET @NOVO_PEDIDO  = 90000000 + 1
	  END
	  ELSE
	  BEGIN	
		  SELECT TOP 1
				@NOVO_PEDIDO = 90000000 + @ID_OCORRENCIA, 
				@DATA_ATUAL = CONVERT(DATETIME, CONVERT(VARCHAR, GETDATE(), 112)), 
				@COD_FORMA_PGTO = CASE @ID_TIPO_DEVOLUCAO WHEN 1 THEN '**' ELSE '$$' END 
		  FROM 
				B2C_OCORRENCIA 
		  
	  END 
	  
	  SELECT 
			@CODIGO_FILIAL_ORIGEM = A.CODIGO_FILIAL_ORIGEM 
	  FROM 
			LOJA_PEDIDO A
			INNER JOIN B2C_OCORRENCIA B ON A.PEDIDO = B.PEDIDO 
	  WHERE 
			B.ID_OCORRENCIA = @ID_OCORRENCIA 
	  
      INSERT INTO LOJA_PEDIDO 
            (CODIGO_FILIAL_ORIGEM, PEDIDO, DATA, CODIGO_FILIAL_RETIRADA, TIPO_PEDIDO, CODIGO_CLIENTE, 
            VENDEDOR, CODIGO_TAB_PRECO, OPERACAO_VENDA, COD_FORMA_PGTO, QTDE_TOTAL, VALOR_TOTAL, OBS, 
            DIGITACAO_ENCERRADA, ID_ENDERECO_ENTREGA, NOME_ENTREGA, MENSAGEM_CARTAO, IDENTIFICACAO_CLIENTE, 
            TRANSPORTADORA, TRACKING, B2C_LOJA, VOLUME, PESO, CODIGO_SITE, FORMA_ENVIO, STATUS_B2C, ID_PEDIDO_ORIGEM, PEDIDO_ID_ORIGEM ) 
      SELECT 
            C.CODIGO_FILIAL_ORIGEM, @NOVO_PEDIDO, @DATA_ATUAL, C.CODIGO_FILIAL_RETIRADA, '4', C.CODIGO_CLIENTE, 
            C.VENDEDOR, C.CODIGO_TAB_PRECO, C.OPERACAO_VENDA, @COD_FORMA_PGTO, 0, 0, 
            'DEVOLUO DO PEDIDO ' + CONVERT(VARCHAR, C.PEDIDO) + ' - OCORRNCIA ' + CONVERT(VARCHAR, @ID_OCORRENCIA), 
            1 AS DIGITACAO_ENCERRADA, C.ID_ENDERECO_ENTREGA, C.NOME_ENTREGA, C.MENSAGEM_CARTAO, C.IDENTIFICACAO_CLIENTE, C.TRANSPORTADORA, 
           NULL, 1 AS B2C_LOJA, C.VOLUME, C.PESO, C.CODIGO_SITE, C.FORMA_ENVIO, 9, C.PEDIDO AS ID_PEDIDO_ORIGEM, C.PEDIDO_ID_ORIGEM  
     FROM 
            B2C_OCORRENCIA A 
            INNER JOIN B2C_OCORRENCIA_PRODUTO B ON A.ID_OCORRENCIA = B.ID_OCORRENCIA 
            INNER JOIN LOJA_PEDIDO C ON A.CODIGO_FILIAL_ORIGEM = C.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = C.PEDIDO 
            INNER JOIN LOJA_PEDIDO_PRODUTO D ON A.CODIGO_FILIAL_ORIGEM = D.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = D.PEDIDO AND B.CODIGO_BARRA = D.CODIGO_BARRA 
      WHERE 
            A.ID_OCORRENCIA = @ID_OCORRENCIA 
      GROUP BY 
            C.CODIGO_FILIAL_ORIGEM, C.CODIGO_FILIAL_RETIRADA, C.TIPO_PEDIDO, C.CODIGO_CLIENTE, C.VENDEDOR, 
            C.CODIGO_TAB_PRECO, C.OPERACAO_VENDA, C.PEDIDO, C.PEDIDO_ID_ORIGEM, C.ID_ENDERECO_ENTREGA, C.NOME_ENTREGA, C.MENSAGEM_CARTAO, 
            C.IDENTIFICACAO_CLIENTE, C.TRANSPORTADORA, C.TRACKING, C.VOLUME, C.PESO, C.CODIGO_SITE, C.FORMA_ENVIO
            
      INSERT INTO LOJA_PEDIDO_PRODUTO 
            (CODIGO_FILIAL_ORIGEM, PEDIDO, ITEM, CODIGO_BARRA, TAMANHO, QTDE, PRECO_LIQUIDO, DESCONTO_ITEM, 
            PRODUTO, COR_PRODUTO, ID_VENDEDOR, QTDE_DEVOLVIDA, QTDE_TERCEIRO, INDICA_ENTREGA_FUTURA, 
            DATA_ENTREGA, EMBRULHA_PRESENTE, B2C_CAMISA_NOME, B2C_CAMISA_NUMERO, B2C_NOME_PERSONALIZACAO, 
            B2C_NUMERO_PERSONALIZACAO, CONFERIDO, QTDE_CONFERIDA) 
      SELECT 
            D.CODIGO_FILIAL_ORIGEM, @NOVO_PEDIDO,  D.ITEM, D.CODIGO_BARRA, D.TAMANHO, B.QTDE * -1 AS QTDE, 
			D.PRECO_LIQUIDO *-1, D.DESCONTO_ITEM, D.PRODUTO, D.COR_PRODUTO, 1, D.QTDE_DEVOLVIDA, D.QTDE_TERCEIRO, 
			D.INDICA_ENTREGA_FUTURA, D.DATA_ENTREGA, D.EMBRULHA_PRESENTE, D.B2C_CAMISA_NOME, D.B2C_CAMISA_NUMERO, 
			D.B2C_NOME_PERSONALIZACAO, D.B2C_NUMERO_PERSONALIZACAO, D.CONFERIDO, 0 
      FROM 
            B2C_OCORRENCIA A 
            INNER JOIN B2C_OCORRENCIA_PRODUTO B ON A.ID_OCORRENCIA = B.ID_OCORRENCIA 
            INNER JOIN LOJA_PEDIDO C ON A.CODIGO_FILIAL_ORIGEM = C.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = C.PEDIDO 
            INNER JOIN LOJA_PEDIDO_PRODUTO D ON A.CODIGO_FILIAL_ORIGEM = D.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = D.PEDIDO AND B.CODIGO_BARRA = D.CODIGO_BARRA 
      WHERE 
            A.ID_OCORRENCIA = @ID_OCORRENCIA 
            AND B.QTDE > 0
            
           
       SELECT @ITEM  = MAX(ITEM) FROM LOJA_PEDIDO_PRODUTO WHERE PEDIDO = @NOVO_PEDIDO
           
      INSERT INTO LOJA_PEDIDO_PRODUTO
            (CODIGO_FILIAL_ORIGEM, PEDIDO, ITEM, CODIGO_BARRA, TAMANHO, QTDE, PRECO_LIQUIDO, DESCONTO_ITEM, 
            PRODUTO, COR_PRODUTO, ID_VENDEDOR, QTDE_DEVOLVIDA, QTDE_TERCEIRO, INDICA_ENTREGA_FUTURA, 
            EMBRULHA_PRESENTE) 
      SELECT 
            C.CODIGO_FILIAL_ORIGEM, @NOVO_PEDIDO, B.ID_ITEM + @ITEM , B.CODIGO_BARRA, B.TAMANHO, B.QTDE AS QTDE, 
            B.PRECO_LIQUIDO , 0, B.PRODUTO, B.COR_PRODUTO, 1, 0, 0, 
            0, 0
      FROM 
            B2C_OCORRENCIA A 
            INNER JOIN B2C_OCORRENCIA_TROCA B ON A.ID_OCORRENCIA = B.ID_OCORRENCIA 
            INNER JOIN LOJA_PEDIDO C ON A.CODIGO_FILIAL_ORIGEM = C.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = C.PEDIDO 
      WHERE 
            A.ID_OCORRENCIA = @ID_OCORRENCIA 
            AND B.QTDE > 0      
            
      UPDATE 
		B2C_OCORRENCIA
	  SET
		PEDIDO_TROCA =  @NOVO_PEDIDO
	  WHERE
		ID_OCORRENCIA = @ID_OCORRENCIA      
            
      UPDATE 
		A
	  SET 
		QTDE_TOTAL = B.QTDE + C.QTDE, 
		VALOR_TOTAL = (B.QTDE * B.PRECO_LIQUIDO)*-1 + (C.QTDE * C.PRECO_LIQUIDO),
		TRACKING = NULL 
	  FROM 
		LOJA_PEDIDO A
		INNER JOIN LOJA_PEDIDO_PRODUTO B ON A.CODIGO_FILIAL_ORIGEM  = B.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = B.PEDIDO AND B.QTDE < 0
		INNER JOIN LOJA_PEDIDO_PRODUTO C ON A.CODIGO_FILIAL_ORIGEM  = C.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = C.PEDIDO AND C.QTDE > 0
		INNER JOIN B2C_OCORRENCIA D ON A.PEDIDO = D.PEDIDO_TROCA AND A.CODIGO_FILIAL_ORIGEM = D.CODIGO_FILIAL_ORIGEM
	 WHERE	
		ID_OCORRENCIA =  @ID_OCORRENCIA 
 
      INSERT LOJA_PEDIDO_VENDEDOR 
            (CODIGO_FILIAL_ORIGEM, PEDIDO, ID_VENDEDOR, TIPO_VENDEDOR, VENDEDOR) 
      SELECT 
            B.CODIGO_FILIAL_ORIGEM, @NOVO_PEDIDO, 1, 1, B.VENDEDOR 
      FROM 
            B2C_OCORRENCIA A 
            INNER JOIN LOJA_PEDIDO B ON A.CODIGO_FILIAL_ORIGEM = B.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = B.PEDIDO 
      WHERE 
            A.ID_OCORRENCIA = @ID_OCORRENCIA 
 
      INSERT INTO LOJA_PEDIDO_PGTO 
            (CODIGO_FILIAL_ORIGEM, PEDIDO, PARCELA, TIPO_PGTO, VALOR, VENCIMENTO, NUMERO_TITULO, 
            MOEDA, CAPTURADO) 
      SELECT 
            CODIGO_FILIAL_ORIGEM, PEDIDO, '01', CASE @ID_TIPO_DEVOLUCAO WHEN 1 THEN 'R' ELSE 'T' END, VALOR_TOTAL, 
            @DATA_ATUAL + 365, 'T' + RTRIM(CODIGO_FILIAL_ORIGEM) + CONVERT(VARCHAR, @NOVO_PEDIDO), 'R$', 1 
      FROM 
            LOJA_PEDIDO 
      WHERE 
            CODIGO_FILIAL_ORIGEM = @CODIGO_FILIAL_ORIGEM AND PEDIDO = @NOVO_PEDIDO
            
 
      SET NOCOUNT OFF
 
      SELECT @NOVO_PEDIDO AS NOVO_PEDIDO
END



GO


