-- Tabela para Operao Triangular
			IF EXISTS (SELECT 1 FROM sys.OBJECTS where name = 'LOJA_PEDIDO_B2C_TRIANGULAR' )
				DROP TABLE [DBO].[LOJA_PEDIDO_B2C_TRIANGULAR]
			GO
			
			CREATE TABLE [dbo].[LOJA_PEDIDO_B2C_TRIANGULAR](
														[CODIGO_FILIAL_ORIGEM]		[char](6)		NOT NULL,
														[PEDIDO]					[int]			NOT NULL,
														[NF_NUMERO_ESTABELECIMENTO]	[char](15)		NULL,
														[SERIE_NF_ESTABELECIMENTO]	[varchar](6)    NULL,
														[NF_NUMERO_CONSUMIDOR]		[char](15)		NULL,
														[SERIE_NF_CONSUMIDOR]		[varchar](6)    NULL,
														[FILIAL_VENDA]				[varchar](25)   NULL,
														[DATA_VENDA]				[datetime]		NULL,
														[TICKET_VENDA]				[char](8)		NULL,
														[NF_NUMERO_VENDA]			[char](15)		NULL,
														[SERIE_NF_VENDA]			[varchar](6)    NULL,
														[CHAVE_NFE]					[varchar](44)	NULL,
																													
			 CONSTRAINT [XPKLOJA_PEDIDO_B2C_TRIANGULAR] PRIMARY KEY CLUSTERED 
			(
				[PEDIDO] ASC,
				[CODIGO_FILIAL_ORIGEM] ASC
			)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
			) ON [PRIMARY] 

			GO
			
			ALTER TABLE [dbo].[LOJA_PEDIDO_B2C_TRIANGULAR]  WITH NOCHECK ADD  CONSTRAINT [XFK13947_LOJA_PEDIDO_B2C_TRIANGULAR] FOREIGN KEY([PEDIDO], [CODIGO_FILIAL_ORIGEM])
			REFERENCES [dbo].[LOJA_PEDIDO] ([PEDIDO], [CODIGO_FILIAL_ORIGEM])
			ON UPDATE CASCADE
			ON DELETE CASCADE
			NOT FOR REPLICATION 
			
			GO

			ALTER TABLE [dbo].[LOJA_PEDIDO_B2C_TRIANGULAR] CHECK CONSTRAINT [XFK13947_LOJA_PEDIDO_B2C_TRIANGULAR]
			
			GO


