
CREATE VIEW [dbo].[W_B2C_CONSULTA_PEDIDO_FATURADO]
AS
SELECT 	NOTA.CODIGO_FILIAL				AS CODIGO_FILIAL,
		LOJAS_VAREJO.FILIAL				AS FILIAL,
		NOTA.TIPO_ORIGEM				AS TIPO_ORIGEM,
		CASE
			WHEN NOTA.TIPO_ORIGEM = '1' 
				THEN 'VENDA'
			WHEN NOTA.TIPO_ORIGEM = '2'
				THEN 'TROCA'
			ELSE 'INDEF' END			AS TIPO_ORIGEM_DESC,
	    LOJA_PEDIDO_VENDA_B2C.PEDIDO	AS PEDIDO,
		LOJA_PEDIDO.TIPO_PEDIDO			AS TIPO_PEDIDO,
		CASE
		WHEN LOJA_PEDIDO.TIPO_PEDIDO = 4
			THEN 'VENDA E-COMMERCE'
		WHEN LOJA_PEDIDO.TIPO_PEDIDO = 5
			THEN 'LISTA CASAMENTO'
		WHEN LOJA_PEDIDO.TIPO_PEDIDO = 6
			THEN 'VENDA PRESENTE'
		WHEN LOJA_PEDIDO.TIPO_PEDIDO = 7
			THEN 'VENDA TRIANGULAR'
		ELSE 'INDEF' END				AS TIPO_PEDIDO_DESC,
		LOJA_PEDIDO.PEDIDO_ID_ORIGEM	AS PEDIDO_ID_ORIGEM,
		LOJA_PEDIDO.ID_PEDIDO_ORIGEM	AS ID_PEDIDO_ORIGEM,
		LOJA_PEDIDO.ID_ENTREGA_ORIGEM   AS ID_ENTREGA_ORIGEM,
		LOJA_VENDA.TICKET				AS TICKET, 
		LOJA_VENDA.TERMINAL				AS TERMINAL, 
		LOJA_VENDA.DATA_VENDA			AS DATA_VENDA, 
		LOJA_VENDA.LANCAMENTO_CAIXA		AS LANCAMENTO_CAIXA,
		NOTA.NF_NUMERO					AS NF_NUMERO, 
		NOTA.SERIE_NF					AS SERIE_NF,
		NOTA.CODIGO_CLIENTE				AS CODIGO_CLIENTE,
		NOTA.NATUREZA_OPERACAO_CODIGO	AS NATUREZA_OPERACAO_CODIGO,
		NOTA.EMISSAO					AS EMISSAO_NF,
		NOTA.DATA_SAIDA					AS DATA_SAIDA_NF,
		NOTA.QTDE_TOTAL					AS QTDE_TOTAL,
		NOTA.FRETE_A_PAGAR				AS FRETE_A_PAGAR,
		CASE 
		WHEN NOTA.FRETE_A_PAGAR = '0' 
			THEN 'Por conta do destinatrio/remetente.'
		WHEN NOTA.FRETE_A_PAGAR = '1' 
			THEN 'Por conta do emitente.'
		WHEN NOTA.FRETE_A_PAGAR = '2' 
			THEN 'Por conta de terceiros.'
		WHEN NOTA.FRETE_A_PAGAR = '3' 
			THEN 'Transporte Prprio por conta do Remetente.'
		WHEN NOTA.FRETE_A_PAGAR = '4' 
			THEN 'Transporte Prprio por conta do Destinatrio.'
		WHEN NOTA.FRETE_A_PAGAR = '9' 
			THEN 'Sem frete.'
		ELSE 'Indef.' END				AS FRETE_A_PAGAR_DESC,
		NOTA.FRETE						AS VALOR_FRETE,
		NOTA.SEGURO						AS SEGURO,
		NOTA.VALOR_TOTAL_ITENS			AS VALOR_TOTAL_ITENS,
		NOTA.DESCONTO					AS DESCONTO,
		NOTA.ENCARGO					AS ENCARGO, 
		NOTA.VALOR_IMPOSTO_AGREGAR		AS VALOR_IMPOSTO_AGREGAR,
		NOTA.VALOR_TOTAL				AS VALOR_TOTAL,
		NOTA.NOTA_IMPRESSA				AS NOTA_IMPRESSA,
		NOTA.STATUS_NFE					AS STATUS_NFE,
		NOTA.LOG_STATUS_NFE				AS LOG_STATUS_NFE,
		CASE	
			WHEN NOTA.STATUS_NFE = '1' AND NOTA.LOG_STATUS_NFE	= '0'
			THEN 'Nf-e no enviada'
			WHEN NOTA.STATUS_NFE = '2' AND NOTA.LOG_STATUS_NFE	= '0'
			THEN 'Nf-e aguardando envio'
			WHEN NOTA.STATUS_NFE = '2' AND NOTA.LOG_STATUS_NFE	= '99'
			THEN 'Erro ao validar Nf-e'
			WHEN NOTA.STATUS_NFE = '3' AND NOTA.LOG_STATUS_NFE	= '0'
			THEN 'Nf-e enviada'
			WHEN NOTA.STATUS_NFE = '4' AND NOTA.LOG_STATUS_NFE	= '99'
			THEN 'Nf-e Rejeitada'
			WHEN NOTA.STATUS_NFE = '5' AND NOTA.LOG_STATUS_NFE	= '0'
			THEN 'Nf-e autorizada'
			WHEN NOTA.STATUS_NFE = '42' AND NOTA.LOG_STATUS_NFE	= '0'
			THEN 'Cancelamento aguardando envio'
			WHEN NOTA.STATUS_NFE = '42' AND NOTA.LOG_STATUS_NFE	= '99'
			THEN 'Cancelamento com erro'
			WHEN NOTA.STATUS_NFE = '49' AND NOTA.LOG_STATUS_NFE	= '0'
			THEN 'Cancelada'
			WHEN NOTA.STATUS_NFE = '52' AND NOTA.LOG_STATUS_NFE	= '0'
			THEN 'Inutilizao aguardando envio'
			WHEN NOTA.STATUS_NFE = '52' AND NOTA.LOG_STATUS_NFE	= '99'
			THEN 'Inutilizao com erro'
			WHEN NOTA.STATUS_NFE = '59' AND NOTA.LOG_STATUS_NFE	= '0'
			THEN 'Inutilizada'
			WHEN NOTA.STATUS_NFE = '70' AND NOTA.LOG_STATUS_NFE	= '0'
			THEN 'Uso denegado'
		ELSE 'Indef.' END				AS STATUS_NFE_DESC,
		NOTA.CHAVE_NFE					AS CHAVE_NFE,
		NOTA.PROTOCOLO_AUTORIZACAO_NFE  AS PROTOCOLO_AUTORIZACAO_NFE,
		NOTA.DATA_AUTORIZACAO_NFE		AS DATA_AUTORIZACAO_NFE,
		NOTA.TRANSPORTADORA				AS TRANSPORTADORA,
		NOTA.TRANSP_RAZAO_SOCIAL		AS RAZAO_SOCIAL_TRANSPORTADORA
FROM dbo.LOJA_NOTA_FISCAL NOTA
	INNER JOIN dbo.LOJAS_VAREJO LOJAS_VAREJO
				ON		LOJAS_VAREJO.CODIGO_FILIAL = NOTA.CODIGO_FILIAL 

	CROSS APPLY (--PESQUISA NF DE VENDA - TIPO ORIGEM 1
				 SELECT '1'							AS TIPO_ORIGEM, 
						VENDA.CODIGO_FILIAL			AS CODIGO_FILIAL, 
						VENDA.TERMINAL				AS TERMINAL, 
						VENDA.LANCAMENTO_CAIXA		AS LANCAMENTO_CAIXA, 
						VENDA.NUMERO_FISCAL_VENDA	AS NF, 
						VENDA.SERIE_NF_SAIDA		AS SERIE_NF  
						FROM dbo.LOJA_VENDA_PGTO VENDA 
							WHERE VENDA.CODIGO_FILIAL = NOTA.CODIGO_FILIAL AND VENDA.NUMERO_FISCAL_VENDA = NOTA.NF_NUMERO AND VENDA.SERIE_NF_SAIDA = NOTA.SERIE_NF 
				UNION
				--PESQUISA NF DE TROCA - TIPO ORIGEM 2
				SELECT	'2'							AS TIPO_ORIGEM, 
						TROCA.CODIGO_FILIAL			AS CODIGO_FILIAL, 
						TROCA.TERMINAL				AS TERMINAL, 
						TROCA.LANCAMENTO_CAIXA		AS LANCAMENTO_CAIXA, 
						TROCA.NUMERO_FISCAL_TROCA	AS NF, 
						TROCA.SERIE_NF_ENTRADA		AS SERIE_NF  
						FROM dbo.LOJA_VENDA_PGTO TROCA 
							WHERE TROCA.CODIGO_FILIAL = NOTA.CODIGO_FILIAL AND TROCA.NUMERO_FISCAL_TROCA = NOTA.NF_NUMERO AND TROCA.SERIE_NF_ENTRADA = NOTA.SERIE_NF 
				) LOJA_VENDA_PGTO

	INNER JOIN  dbo.LOJA_VENDA LOJA_VENDA			
				ON		LOJA_VENDA.CODIGO_FILIAL	= LOJA_VENDA_PGTO.CODIGO_FILIAL 
					AND LOJA_VENDA.TERMINAL			= LOJA_VENDA_PGTO.TERMINAL 
					AND LOJA_VENDA.LANCAMENTO_CAIXA = LOJA_VENDA_PGTO.LANCAMENTO_CAIXA 
	
	CROSS APPLY ( SELECT	DISTINCT 
							CODIGO_FILIAL_ORIGEM AS CODIGO_FILIAL_ORIGEM,
							PEDIDO AS PEDIDO
					FROM dbo.LOJA_PEDIDO_VENDA LOJA_PEDIDO_VENDA
					WHERE LOJA_PEDIDO_VENDA.TICKET			= LOJA_VENDA.TICKET 
					AND		LOJA_PEDIDO_VENDA.CODIGO_FILIAL = LOJA_VENDA.CODIGO_FILIAL 
					AND		LOJA_PEDIDO_VENDA.DATA_VENDA	= LOJA_VENDA.DATA_VENDA ) LOJA_PEDIDO_VENDA_B2C
	INNER JOIN dbo.LOJA_PEDIDO LOJA_PEDIDO
				ON LOJA_PEDIDO.PEDIDO = LOJA_PEDIDO_VENDA_B2C.PEDIDO AND LOJA_PEDIDO.CODIGO_FILIAL_ORIGEM = LOJA_PEDIDO_VENDA_B2C.CODIGO_FILIAL_ORIGEM 
WHERE 
	LOJA_PEDIDO.TIPO_PEDIDO IN (4, 5, 6, 7) -- Tipo Pedido B2C - 4 E-commerce, 5 Lista Casamento, 6 Ecommerce Presente e 7 Operao triangular





		

GO


