/****** Object:  View [dbo].[W_B2C_PEDIDOS_WEB]    Script Date: 10/06/2019 21:52:48 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

				CREATE VIEW [dbo].[W_B2C_PEDIDOS_WEB] 
					AS 
					SELECT 
						A.CODIGO_FILIAL_ORIGEM, A.PEDIDO, 
						CAST(CONVERT(VARCHAR(10), A.DATA,112) AS DATETIME) AS DATA, 
						A.CODIGO_CLIENTE, B.CLIENTE_VAREJO, B.CPF_CGC, B.PF_PJ, B.RG_IE, 
						CASE
							WHEN A.TIPO_PEDIDO = 4 THEN 'PEDIDO' 
							WHEN A.TIPO_PEDIDO = 6 THEN 'PRESENTE' 
							WHEN A.TIPO_PEDIDO = 5 THEN 'LISTA' 
							WHEN A.TIPO_PEDIDO = 7 THEN 'RESHOP' 
						END AS TIPO_PEDIDO, 
					    A.QTDE_TOTAL, A.VALOR_TOTAL, A.DESCONTO, A.CANCELADO, A.ENTREGUE, A.DIGITACAO_ENCERRADA, ISNULL(A.TRACKING, '') AS TRACKING, A.FRETE, 
					    ISNULL(A.NOME_ENTREGA, '') AS NOME_ENTREGA, ISNULL(A.MENSAGEM_CARTAO, '') AS MENSAGEM_CARTAO, A.transportadora, A.ID_ENDERECO_ENTREGA, 
					    ISNULL(A.FORMA_ENVIO, '')  AS FORMA_ENVIO, 
						'SITE PADRAO' AS NOME_SITE, 
					    ISNULL(RTRIM(B.TIPO_LOGRADOURO), '') + ' ' + ISNULL(RTRIM(B.ENDERECO), '') AS ENDERECO,   ISNULL(RTRIM(B.NUMERO), '')  AS NUMERO, ISNULL(RTRIM(B.COMPLEMENTO),'') AS COMPLEMENTO, 
					    ISNULL(B.BAIRRO, '') AS BAIRRO, ISNULL(B.CIDADE, '') AS CIDADE, ISNULL(B.UF, '') AS UF, ISNULL(B.CEP, '') AS CEP, 
					    ISNULL(RTRIM(D.LOGRADOURO) , ISNULL(RTRIM(B.TIPO_LOGRADOURO), '')+' ' + ISNULL(RTRIM(B.ENDERECO),'')) AS ENDERECO_ENTREGA, 
					    ISNULL(RTRIM(D.NUMERO), ISNULL(RTRIM(B.NUMERO), '')) AS NUMERO_ENTREGA, ISNULL(RTRIM(D.COMPLEMENTO),ISNULL(RTRIM(B.COMPLEMENTO),'')) AS COMPLEMENTO_ENTREGA, 
					    ISNULL(D.BAIRRO, ISNULL(B.BAIRRO, '')) AS BAIRRO_ENTREGA, ISNULL(D.CIDADE, ISNULL(B.CIDADE, '')) AS CIDADE_ENTREGA, 
					    ISNULL(D.UF, ISNULL(B.UF, '')) AS UF_ENTREGA, ISNULL(D.CEP, ISNULL(B.CEP, '')) AS CEP_ENTREGA, ISNULL(B.DDD, '') AS DDD, ISNULL(B.TELEFONE, '') AS TELEFONE, 
					    ISNULL(H.EMAIL,'') AS EMAIL_CONTATO, ISNULL(B.EMAIL,'') AS EMAIL, ISNULL(H.DDD1,'') AS DDD_ENTREGA, ISNULL(H.TELEFONE1,'') AS TELEFONE_ENTREGA, 
					    E.STATUS, A.STATUS_CLEARSALE, A.STATUS_B2C, A.CODIGO_FILIAL_VENDA, A.VENDEDOR, 
					   ROUND(CAST((VALOR_TOTAL * (I.COMISSAO/100)) AS NUMERIC(16,2)),2) AS COMISSAO_VENDEDOR,  J.VENDEDOR_APELIDO, L.FILIAL AS LOJA, A.PERIODO_AGENDAMENTO, A.DATA_AGENDAMENTO,
					   A.VOLUME, A.PEDIDO_ID_ORIGEM 
					FROM 
						LOJA_PEDIDO 					AS A             
						LEFT JOIN CLIENTES_VAREJO 		AS B ON A.CODIGO_CLIENTE = B.CODIGO_CLIENTE 
						LEFT JOIN B2C_SITES 			AS C ON A.Codigo_Site = C.CODIGO_SITE 
						LEFT JOIN CONTATO_ENDERECO 		AS D ON A.ID_ENDERECO_ENTREGA = D.ID_ENDERECO 
						INNER JOIN W_B2C_PEDIDO_STATUS 	AS E ON A.PEDIDO = E.PEDIDO AND A.CODIGO_FILIAL_ORIGEM = E.CODIGO_FILIAL_ORIGEM 
						LEFT JOIN CONTATO 				AS H ON D.CODIGO_CONTATO = H.CODIGO_CONTATO 
						LEFT JOIN B2C_VENDEDORES 		AS I ON A.VENDEDOR = I.VENDEDOR
						LEFT JOIN LOJA_VENDEDORES 		AS J ON I.VENDEDOR = J.VENDEDOR 
						LEFT JOIN FILIAIS 				AS L ON A.CODIGO_FILIAL_VENDA = L.COD_FILIAL
					WHERE 
						A.TIPO_PEDIDO in (4, 5, 6, 7)
					
GO


