create VIEW [dbo].[W_B2C_PEDIDO_STATUS]  
AS  
--07/06/2019 - EDSON FILENTI  - MODASP-2551	- #1# - Correo na validao dos pagamentos. H pedidos com mais de uma forma de PGTO sem captura.
SELECT  DISTINCT
  A.PEDIDO, A.CODIGO_FILIAL_ORIGEM,  
 CASE
   WHEN A.STATUS_B2C = '5' THEN 'PEDIDO COM PROBLEMA'
   WHEN E.PEDIDO_ABERTO = 1 AND E.BOLETO = 1 AND MAX(CAST(C.CAPTURADO AS TINYINT)) = 0 AND A.CANCELADO = 0 AND FORMA_PGTO_PENDENTE = 0 AND ISNULL(A.B2C_lOJA, 0) = 0 THEN 'AGUARDANDO CONCILIAO'  
   WHEN E.PEDIDO_ABERTO = 1 AND E.CARTAO = 1  AND MAX(CAST(C.CAPTURADO AS TINYINT)) = 0 AND A.CANCELADO = 0  AND FORMA_PGTO_PENDENTE = 0 AND ISNULL(A.B2C_lOJA, 0) = 0 THEN 'AGUARDANDO CAPTURA'   
   WHEN A.CANCELADO = 1 THEN 'CANCELADO'  
   WHEN A.DIGITACAO_ENCERRADA = 0 AND A.CANCELADO = 0 THEN 'DIGITAO NO ENCERRADA'   
   WHEN E.PEDIDO_ABERTO = 1 AND E.FORMA_PGTO_PENDENTE = 1 AND A.CANCELADO = 0 AND ISNULL(A.B2C_lOJA, 0) = 1  THEN 'AGUARDANDO FORMA DE PAGAMENTO'  
   WHEN E.PEDIDO_ABERTO = 1 AND E.FORMA_PGTO_PENDENTE = 1 AND A.CANCELADO = 0 AND ISNULL(A.B2C_lOJA, 0) = 0 THEN 'PEDIDO DO SITE SEM PAGAMENTO'  
   WHEN E.CARTAO_BOLETO = 1 AND DIGITACAO_ENCERRADA = 1 THEN 'SEM NMERO DE APROVAO OU TITULO'  
   WHEN E.PEDIDO_ABERTO = 0 AND E.ITEM_PENDENTE = 0 AND ISNULL(D.PEDIDO, 0) <> 0 AND A.CANCELADO = 0  AND  CARTAO_BOLETO = 0  THEN 'ENCERRADO'  
   WHEN  E.PEDIDO_ABERTO = 0 AND E.NOTA_PENDENTE = 1 AND E.ITEM_PENDENTE = 0 AND A.CANCELADO = 0  AND  CARTAO_BOLETO = 0  THEN 'AGUARDANDO IMPRESSO NF'  
   WHEN E.PEDIDO_ABERTO = 1 AND  E.ITEM_PENDENTE = 1 AND A.CANCELADO = 0  AND FORMA_PGTO_PENDENTE = 0 AND ISNULL(D.PEDIDO, '') <> ''  THEN 'FATURAMENTO PARCIAL'  
   WHEN E.PEDIDO_ABERTO = 0 AND E.ITEM_PENDENTE = 0 AND  A.CANCELADO = 0  AND  CARTAO_BOLETO = 0 AND ISNULL(D.PEDIDO, '') = '' THEN 'PEDIDO COM PROBLEMA'
   
   ELSE 'LIBERADO PARA FATURAMENTO'  END AS STATUS  
FROM   
 LOJA_PEDIDO A          
	INNER JOIN W_B2C_LJ_PEDIDO_PRODUTO B ON A.CODIGO_FILIAL_ORIGEM = B.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = B.PEDIDO           
    --LEFT OUTER JOIN W_B2C_LJ_PEDIDO_PGTO C ON A.CODIGO_FILIAL_ORIGEM = C.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = C.PEDIDO          
	LEFT OUTER JOIN (SELECT TOP 1 PagPend.CODIGO_FILIAL_ORIGEM, PagPend.PEDIDO, ISNULL(PagPend.CAPTURADO, 0) AS CAPTURADO FROM DBO.LOJA_PEDIDO_PGTO PagPend ORDER BY PagPend.CAPTURADO  ) C ON A.CODIGO_FILIAL_ORIGEM = C.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = C.PEDIDO 
	LEFT OUTER JOIN W_B2C_LJ_NF_VALIDA D ON  A.CODIGO_FILIAL_ORIGEM = D.CODIGO_FILIAL AND A.PEDIDO = D.PEDIDO   
	INNER JOIN W_B2C_INFORMACOES_PEDIDOS E ON A.CODIGO_FILIAL_ORIGEM = E.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = E.PEDIDO
GROUP BY 
	A.PEDIDO,A.STATUS_B2C, A.CODIGO_FILIAL_ORIGEM, E.PEDIDO_ABERTO, E.BOLETO, A.CANCELADO, E.CARTAO, E.FORMA_PGTO_PENDENTE, A.B2C_LOJA,
	A.DIGITACAO_ENCERRADA, E.CARTAO_BOLETO, E.ITEM_PENDENTE, D.PEDIDO, E.NOTA_PENDENTE
GO


