CREATE PROCEDURE dbo.LX_GERA_TRANSFERENCIA_FILIAL_QUALIDADE_B2C @CodigoFilial	CHAR(6)	=	NULL,  
																@Ticket			CHAR(8)	=	NULL, 
																@DataVenda		VARCHAR(8)	=NULL, 
																@FilialDestino	VARCHAR(25) =NULL, 
																@Operacao		CHAR(1) = 'U'
AS
BEGIN
	DECLARE @Retorno				VARCHAR(100),
			@MsgErro				VARCHAR(1000),
			@MatrizFiscal			VARCHAR(25),
			@AtivaGeracaoTransf		BIT, 
			@EmpresaFilial			INT,
			@RomaneioProduto		CHAR(8),
			@RomaneioProdutoDestino Char(8),
			@FilialOrigem			VARCHAR(25),
			@Responsavel			VARCHAR(100),
			@TipoRomaneio			VARCHAR(25),
			@CMOperacao				VARCHAR(10),
			@Obs					VARCHAR(2000),
			@Comando				VARCHAR(400),
			@Numero_Fiscal_Troca	char(15),	
			@Serie_Nf_Entrada		varchar(6),
			@Numero_Fiscal_Venda	char(15),
			@Serie_Nf_Saida			varchar(6),
			@DataLog				DATETIME
			
/********************************************* 
Operaes da Procedure
@Operacao =  I - Insere Romaneio
			 D - Deleta Romaneio
*********************************************/ 	

-- Validaes
/*********************************************/
						SELECT @Responsavel				= SYSTEM_USER, @DataLog = GETDATE()
						SELECT	@Retorno				= NULL, 
								@MsgErro				= NULL, 
								@MatrizFiscal			= NULL,
								@RomaneioProduto		= NULL, 
								@RomaneioProdutoDestino = NULL,
								@Numero_Fiscal_Troca	= NULL,
								@Serie_Nf_Entrada		= NULL,
								@Numero_Fiscal_Venda	= NULL,
								@Serie_Nf_Saida			= NULL,	
								@CMOperacao				= '',
								@TipoRomaneio			= 'TRANSFERENCIA',
								@Obs					= 'Transferncia Automtica gerado por uma devoluo no B2C. Referente ao Ticket: ' + @Ticket + '. ' + char(13) +
														  'Usurio Sistema: '+ @Responsavel
						
								
								

					-- Validao da Operao 
							 IF @Operacao NOT IN ('I', 'D')
								BEGIN
									SET @MsgErro = 'Operao no definida. Verifique o parmetro @Operacao na execuo da procedure LX_GERA_TRANSFERENCIA_FILIAL_2_QUALIDADE_B2C '
									GOTO ERROR
								END
						
					-- Valida Parmtros
						IF @CodigoFilial IS NULL OR  @Ticket IS NULL OR @DataVenda IS NULL OR LEN(@CodigoFilial) = 0 OR LEN(@Ticket) = 0 OR LEN(@DataVenda) = 0
							BEGIN
								SET @MsgErro = 'Parmetros Invlidos. Verifique os parmetros na execuo da procedure LX_GERA_TRANSFERENCIA_FILIAL_2_QUALIDADE_B2C '
								GOTO ERROR
							END

					-- Insere LOG
						IF NOT EXISTS(SELECT 1 FROM dbo.TRANSFERENCIA_FILIAL_QUALIDADE_LOG_B2C WHERE OPERACAO = @Operacao AND DATA_VENDA = @DataVenda AND CODIGO_FILIAL = @CodigoFilial AND TICKET = @Ticket)
							BEGIN
								INSERT INTO dbo.TRANSFERENCIA_FILIAL_QUALIDADE_LOG_B2C (OPERACAO , CODIGO_FILIAL, TICKET , DATA_VENDA, FILIAL       , RESPONSAVEL , ROMANEIO_SAIDA , EMISSAO_ROMANEIO, FILIAL_DESTINO, ROMANEIO_ENTRADA , NF_ENTRADA          , SERIE_NF_ENTRADA, NF_SAIDA, SERIE_NF_SAIDA, DATA_LOG , COMANDO, OBS )
			  																	VALUES (@Operacao, @CodigoFilial, @Ticket, @DataVenda, NULL			, @Responsavel, NULL           , NULL            , NULL          , NULL             , NULL                , NULL            , NULL    , NULL          , @DataLog , NULL   , ''  )
							END
						
														
					--Verifica se processo de gerao da transferncia est Habilitado.
							IF EXISTS( SELECT 1 FROM dbo.PARAMETROS_LOJA_TERMINAL WHERE PARAMETRO = 'ATIVA_TRANSF_2FILIAL_B2C')
								SELECT @AtivaGeracaoTransf = CASE WHEN VALOR_ATUAL = '.T.' THEN 1 ELSE 0 END FROM dbo.PARAMETROS_LOJA_TERMINAL WHERE PARAMETRO = 'ATIVA_TRANSF_2FILIAL_B2C'
							ELSE
								BEGIN
									SET @MsgErro = 'Parmetro ''ATIVA_TRANSF_2FILIAL_B2C'' no encontrado. Transferncia no gerada!'
									GOTO ERROR
								END
			
					--Verifica Item do custo mdio.
							IF EXISTS( SELECT 1 FROM dbo.PARAMETROS_LOJA_TERMINAL WHERE PARAMETRO = 'CM_OP_TRANSF_2FILIAL_B2C')
								BEGIN
									SELECT @CMOperacao = CASE WHEN LEN(VALOR_ATUAL) = 0 THEN '' ELSE VALOR_ATUAL END FROM dbo.PARAMETROS_LOJA_TERMINAL WHERE PARAMETRO = 'CM_OP_TRANSF_2FILIAL_B2C'
									IF @CMOperacao = ''
									BEGIN
										SET @MsgErro = 'Parmetro ''CM_OP_TRANSF_2FILIAL_B2C'' no informado. Transferncia no gerada!'
										GOTO ERRO_LOG
									END
								END
							ELSE
								BEGIN
									SET @MsgErro = 'Parmetro ''CM_OP_TRANSF_2FILIAL_B2C'' no encontrado. Transferncia no gerada!'
									GOTO ERRO_LOG
								END
					


					--Verifica se Filial de segunda qualidade est configurada.
							IF NOT EXISTS (SELECT FILIAL FROM dbo.FILIAIS WHERE FILIAL = @FilialDestino)
								BEGIN
									SET @MsgErro = 'Parmetro ''FILIAL_2QUALIDADE_B2C'' no encontrado. Transferncia no gerada!'
									GOTO ERRO_LOG
								END
	
							IF lEN(@FilialDestino) = 0 OR @FilialDestino IS NULL OR NOT EXISTS (SELECT 1 FROM dbo.FILIAIS WHERE FILIAL = @FilialDestino)
							 BEGIN
								SET @MsgErro = 'Filial de Destino no encontrada. Verifique o parmetro	''FILIAL_2QUALIDADE_B2C'''
								GOTO ERRO_LOG
							 END
		


					-- Valida Filial de Origem
							IF NOT EXISTS (SELECT FILIAL FROM dbo.LOJAS_VAREJO WHERE CODIGO_FILIAL = @CodigoFilial)
								BEGIN
									SET @MsgErro = 'Cdigo Filial -''' + @CodigoFilial + ''' no encontrada. A transferncia no foi gerada!'
									GOTO ERRO_LOG
								END
							ELSE
								SELECT @FilialOrigem = FILIAL, @EmpresaFilial = EMPRESA, @MatrizFiscal = MATRIZ_FISCAL FROM dbo.FILIAIS WHERE FILIAL = (SELECT FILIAL FROM dbo.LOJAS_VAREJO WHERE CODIGO_FILIAL = @CodigoFilial)
								


					-- Transferncias APENAS para filiais da mesma matriz fiscal - ERP 120027
							IF NOT EXISTS(SELECT 1 FROM dbo.FILIAIS WHERE FILIAL <> @FilialOrigem AND MATRIZ_FISCAL = @MatrizFiscal) OR @MatrizFiscal IS NULL OR LEN(@MatrizFiscal) = 0
								BEGIN
									SET @MsgErro = 'Esta operao deve ser realizada entre filiais com mesma Matriz Fiscal. Verifique a filial indicada no parmetro FILIAL_2QUALIDADE_B2C. A transferncia no foi gerada!'
									GOTO ERRO_LOG
								END
			
			
					--Valida ticket 
							-- Valida a existncia 
							IF NOT EXISTS(SELECT 1 FROM dbo.LOJA_VENDA WHERE CODIGO_FILIAL = @CodigoFilial AND DATA_VENDA = @DataVenda AND TICKET = @Ticket)
								BEGIN
									SET @MsgErro = 'Ticket '''+  @Ticket + ''' no encontrado. No foi possvel realizar a transferncia para filial de Qualidade.'
									GOTO ERRO_LOG
								END
							
							--Valida se h troca
							IF NOT EXISTS(SELECT 1 FROM dbo.LOJA_VENDA A INNER JOIN LOJA_VENDA_TROCA B ON A.CODIGO_FILIAL = B.CODIGO_FILIAL AND A.TICKET = B.TICKET AND A.DATA_VENDA = B.DATA_VENDA WHERE A.CODIGO_FILIAL = @CodigoFilial AND A.DATA_VENDA = @DataVenda AND A.TICKET = @Ticket)
								BEGIN
									SET @MsgErro = 'O Ticket '''+  @Ticket + ''' no possui troca. Processo de transferncia Automtica validado com sucesso.'
																
									GOTO RETORNO
								END
							
							IF EXISTS(SELECT 1 FROM dbo.LOJA_VENDA A INNER JOIN LOJA_VENDA_PGTO B ON A.CODIGO_FILIAL = B.CODIGO_FILIAL AND A.LANCAMENTO_CAIXA = B.LANCAMENTO_CAIXA AND A.TERMINAL = B.TERMINAL WHERE A.CODIGO_FILIAL = @CodigoFilial AND A.DATA_VENDA = @DataVenda AND A.TICKET = @Ticket)
								BEGIN
									SELECT	@Numero_Fiscal_Troca = B.NUMERO_FISCAL_TROCA, 
											@Serie_Nf_Entrada = SERIE_NF_ENTRADA, 
											@Numero_Fiscal_Venda = B.NUMERO_FISCAL_VENDA, 
											@Serie_Nf_Saida = SERIE_NF_SAIDA 
									FROM dbo.LOJA_VENDA A 
										INNER JOIN LOJA_VENDA_PGTO B 
											ON A.CODIGO_FILIAL = B.CODIGO_FILIAL AND A.LANCAMENTO_CAIXA = B.LANCAMENTO_CAIXA AND A.TERMINAL = B.TERMINAL 
									WHERE	A.CODIGO_FILIAL = @CodigoFilial 
									AND		A.DATA_VENDA	= @DataVenda 
									AND		A.TICKET		= @Ticket
								END
								

					-- Verifica sequenciais	
							IF NOT EXISTS (SELECT 1 FROM dbo.SEQUENCIAIS WHERE TABELA_COLUNA = 'ESTOQUE_PROD_SAI.ROMANEIO_PRODUTO')
								BEGIN
									SET @MsgErro = 'Sequencial para gerao do Romaneio no encontrada. Por favor verifique o cadastro de sequenciais.'
									GOTO ERRO_LOG
								END
					-- Comando para log
						SET @Comando = 'EXEC dbo.LX_GERA_TRANSFERENCIA_FILIAL_QUALIDADE_B2C @CodigoFilial = ''' + @CodigoFilial + ''', @Ticket = ''' +  @Ticket + ''', @DataVenda = ''' + @DataVenda + ''', @FilialDestino = ''' + @FilialDestino + ''', @Operacao = ''' + @Operacao + ''''

-- Insere & Deleta Romaneio
/*********************************************/
BEGIN TRY
	-- Inicia processo de transferncia automtica para filial de qualidade.
			IF @AtivaGeracaoTransf = 1
				BEGIN
				  -- Cria Romaneio de transferncia
				  /*********************************************/
									  IF @Operacao = 'I'
										BEGIN
										-- Seleciona nmero sequencial do Romaneio. 
											EXEC LX_SEQUENCIAL @TABELA_COLUNA = 'ESTOQUE_PROD_SAI.ROMANEIO_PRODUTO', @EMPRESA = @EmpresaFilial, @SEQUENCIA = OUTPUT, @UPDATE_SEQUENCIAL = 1, @NEWVALUE = ''
											SELECT  @RomaneioProduto = RIGHT(SEQUENCIA, 7), @RomaneioProdutoDestino = 'T' + RIGHT(SEQUENCIA, 7) FROM dbo.SEQUENCIAIS WHERE TABELA_COLUNA = 'ESTOQUE_PROD_SAI.ROMANEIO_PRODUTO'
											
																		
										-- Insere Sida	
											INSERT INTO ESTOQUE_PROD_SAI(	ROMANEIO_PRODUTO,
																			FILIAL,
																			EMISSAO,
																			RESPONSAVEL,
																			ROMANEIO_DESTINO,
																			FILIAL_DESTINO,
																			OBS,
																			ORDEM_PRODUCAO,
																			SEGUNDA_QUALIDADE,
																			TIPO_ROMANEIO,
																			DATA_DIGITACAO,
																			NF_FILIAL,
																			NF_SAIDA,
																			SERIE_NF,
																			NOME_CLIFOR,
																			NF_ENTRADA,
																			SERIE_NF_ENTRADA,
																			NAO_VALIDAR_ENTRADA,
																			RATEIO_CENTRO_CUSTO,
																			CM_OPERACAO,
																			RATEIO_FILIAL,
																			CONTA_CONTABIL ,
																			CTB_LANCAMENTO,
																			ITEM_IMPRESSAO,
																			MOV_INTERNA)
											SELECT  @RomaneioProduto		AS ROMANEIO_PRODUTO,
													F.FILIAL				AS FILIAL,
													LV.DATA_VENDA			AS EMISSAO,
													'B2C Manager'			AS RESPONSAVEL,
													@RomaneioProdutoDestino	AS ROMANEIO_DESTINO,
													@FilialDestino			AS FILIAL_DESTINO,
													@Obs					AS OBS,
													NULL					AS ORDEM_PRODUCAO,
													0						AS SEGUNDA_QUALIDADE,
													@TipoRomaneio			AS TIPO_ROMANEIO,
													GETDATE()				AS DATA_DIGITACAO,
													NULL					AS NF_FILIAL,
													NULL					AS NF_SAIDA,
													NULL					AS SERIE_NF,
													NULL					AS NOME_CLIFOR,
													NULL					AS NF_ENTRADA,
													NULL					AS SERIE_NF_ENTRADA,
													0						AS NAO_VALIDAR_ENTRADA,
													NULL					AS RATEIO_CENTRO_CUSTO,
													@CMOperacao				AS CM_OPERACAO,
													NULL					AS RATEIO_FILIAL,
													NULL					AS CONTA_CONTABIL ,
													NULL					AS CTB_LANCAMENTO,
													NULL					AS ITEM_IMPRESSAO,
													0						AS MOV_INTERNA
											FROM	DBO.LOJA_VENDA LV
 													INNER JOIN DBO.LOJAS_VAREJO 		ON LV.CODIGO_FILIAL=LOJAS_VAREJO.CODIGO_FILIAL
													INNER JOIN DBO.FILIAIS F			ON F.FILIAL = LOJAS_VAREJO.FILIAL 
											WHERE	LV.CODIGO_FILIAL	= @CodigoFilial 
											AND		LV.TICKET			= @Ticket
											AND		LV.DATA_VENDA		= @DataVenda 

										--Insere Sada Itens
											INSERT INTO dbo.ESTOQUE_PROD1_SAI(	FILIAL,
																				ROMANEIO_PRODUTO,
																				PRODUTO,
																				COR_PRODUTO, 
																				QTDE,
																				SA_1, SA_2, SA_3, SA_4, SA_5, SA_6, SA_7, SA_8, SA_9, SA_10, 
																				SA_11, SA_12, SA_13, SA_14, SA_15, SA_16, SA_17, SA_18, SA_19, SA_20,
																				SA_21, SA_22, SA_23, SA_24, SA_25, SA_26, SA_27, SA_28, SA_29, SA_30, 
																				SA_31, SA_32, SA_33, SA_34, SA_35, SA_36, SA_37, SA_38, SA_39, SA_40, 
																				SA_41, SA_42, SA_43, SA_44, SA_45, SA_46, SA_47, SA_48, 
																				CUSTO1,
																				CUSTO2,
																				CUSTO3,
																				CUSTO4,
																				ITEM_IMPRESSAO,
																				ID_MODIFICACAO,
																				ITEM_IMPRESSAO_ENTRADA,
																				DESCONTO_ITEM,
																				ID_SUB_PROJETO,
																				PEDIDO)
											SELECT	F.FILIAL																			AS FILIAL,
													@RomaneioProduto																	AS ROMANEIO_PRODUTO,
													ISNULL(LVT.PRODUTO,PRODUTOS_BARRA.PRODUTO)											AS PRODUTO,
													ISNULL(LVT.COR_PRODUTO,PRODUTOS_BARRA.COR_PRODUTO)									AS COR_PRODUTO, 
													SUM(QTDE)																			AS QTDE,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 1  THEN QTDE ELSE 0 END)	AS TM_1,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 2  THEN QTDE ELSE 0 END)	AS TM_2,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 3  THEN QTDE ELSE 0 END)	AS TM_3,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 4  THEN QTDE ELSE 0 END)	AS TM_4,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 5  THEN QTDE ELSE 0 END)	AS TM_5,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 6  THEN QTDE ELSE 0 END)	AS TM_6,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 7  THEN QTDE ELSE 0 END)	AS TM_7,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 8  THEN QTDE ELSE 0 END)	AS TM_8,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 9  THEN QTDE ELSE 0 END)	AS TM_9,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 10 THEN QTDE ELSE 0 END)	AS TM_10,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 11 THEN QTDE ELSE 0 END)	AS TM_11,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 12 THEN QTDE ELSE 0 END)	AS TM_12,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 13 THEN QTDE ELSE 0 END)	AS TM_13,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 14 THEN QTDE ELSE 0 END)	AS TM_14,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 15 THEN QTDE ELSE 0 END)	AS TM_15,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 16 THEN QTDE ELSE 0 END)	AS TM_16,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 17 THEN QTDE ELSE 0 END)	AS TM_17,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 18 THEN QTDE ELSE 0 END)	AS TM_18,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 19 THEN QTDE ELSE 0 END)	AS TM_19,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 20 THEN QTDE ELSE 0 END)	AS TM_20,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 21 THEN QTDE ELSE 0 END)	AS TM_21,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 22 THEN QTDE ELSE 0 END)	AS TM_22,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 23 THEN QTDE ELSE 0 END)	AS TM_23,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 24 THEN QTDE ELSE 0 END)	AS TM_24,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 25 THEN QTDE ELSE 0 END)	AS TM_25,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 26 THEN QTDE ELSE 0 END)	AS TM_26,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 27 THEN QTDE ELSE 0 END)	AS TM_27,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 28 THEN QTDE ELSE 0 END)	AS TM_28,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 29 THEN QTDE ELSE 0 END)	AS TM_29,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 30 THEN QTDE ELSE 0 END)	AS TM_30,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 31 THEN QTDE ELSE 0 END)	AS TM_31,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 32 THEN QTDE ELSE 0 END)	AS TM_32,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 33 THEN QTDE ELSE 0 END)	AS TM_33,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 34 THEN QTDE ELSE 0 END)	AS TM_34,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 35 THEN QTDE ELSE 0 END)	AS TM_35,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 36 THEN QTDE ELSE 0 END)	AS TM_36,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 37 THEN QTDE ELSE 0 END)	AS TM_37,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 38 THEN QTDE ELSE 0 END)	AS TM_38,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 39 THEN QTDE ELSE 0 END)	AS TM_39,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 40 THEN QTDE ELSE 0 END)	AS TM_40,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 41 THEN QTDE ELSE 0 END)	AS TM_41,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 42 THEN QTDE ELSE 0 END)	AS TM_42,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 43 THEN QTDE ELSE 0 END)	AS TM_43,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 44 THEN QTDE ELSE 0 END)	AS TM_44,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 45 THEN QTDE ELSE 0 END)	AS TM_45,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 46 THEN QTDE ELSE 0 END)	AS TM_46,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 47 THEN QTDE ELSE 0 END)	AS TM_47,
													SUM(CASE ISNULL(LVT.TAMANHO,PRODUTOS_BARRA.TAMANHO) WHEN 48 THEN QTDE ELSE 0 END)	AS TM_48,
													CONVERT(NUMERIC(14,2),AVG(PRECO_LIQUIDO))											AS CUSTO1,
													0.00																				AS CUSTO2,
													0.00																				AS CUSTO3,
													0.00																				AS CUSTO4,
													NULL																				AS ITEM_IMPRESSAO,
													NULL																				AS ID_MODIFICACAO,
													NULL																				AS ITEM_IMPRESSAO_ENTRADA,
													CONVERT(NUMERIC(14,2),SUM(QTDE*DESCONTO_ITEM))										AS DESCONTO_ITEM,
													NULL																				AS ID_SUB_PROJETO,
													NULL																				AS PEDIDO
										 FROM	DBO.LOJA_VENDA LV
											INNER JOIN DBO.LOJA_VENDA_TROCA LVT ON LVT.TICKET = LV.TICKET AND LVT.CODIGO_FILIAL = LV.CODIGO_FILIAL AND LVT.DATA_VENDA = LV.DATA_VENDA
 											INNER JOIN DBO.LOJAS_VAREJO 		ON LVT.CODIGO_FILIAL=LOJAS_VAREJO.CODIGO_FILIAL
											INNER JOIN DBO.FILIAIS F			ON F.FILIAL = LOJAS_VAREJO.FILIAL 
											LEFT  JOIN DBO.PRODUTOS_BARRA		ON PRODUTOS_BARRA.CODIGO_BARRA=LVT.CODIGO_BARRA
										 WHERE		LV.CODIGO_FILIAL	= @CodigoFilial 
										 AND		LV.TICKET			= @Ticket
										 AND		LV.DATA_VENDA		= @DataVenda
										 GROUP BY LVT.PRODUTO, LVT.COR_PRODUTO, F.FILIAL, LV.DATA_VENDA, PRODUTOS_BARRA.PRODUTO, PRODUTOS_BARRA.COR_PRODUTO

											if @@ERROR = 0
												BEGIN
													--Atualiza LOG
													UPDATE dbo.TRANSFERENCIA_FILIAL_QUALIDADE_LOG_B2C
													SET ROMANEIO_SAIDA		= @RomaneioProduto,
														EMISSAO_ROMANEIO	= @DataVenda,
														ROMANEIO_ENTRADA	= @RomaneioProdutoDestino,
														RESPONSAVEL			= @Responsavel,
														FILIAL				= @FilialOrigem,
														FILIAL_DESTINO		= @FilialDestino,
														NF_ENTRADA			= @Numero_Fiscal_Troca,
														SERIE_NF_ENTRADA	= @Serie_Nf_Entrada,
														NF_SAIDA			= @Numero_Fiscal_Venda,
														SERIE_NF_SAIDA		= @Serie_Nf_Saida,
														COMANDO				= @Comando,
														OBS					= @Obs 
													WHERE	CODIGO_FILIAL	= @CodigoFilial
													AND		TICKET			= @Ticket
													AND		DATA_VENDA		= @DataVenda
													AND		OPERACAO		= @Operacao
													

													SET @RETORNO = 'Transferncia Gerada. Romaneio Sada - ' + @RomaneioProduto + ' | Romaneio Entrada - ' + @RomaneioProdutoDestino
													GOTO RETORNO
												END
											ELSE
												BEGIN
													--Atualiza LOG
													SET @MsgErro = '| ' + CONVERT(VARCHAR(20), @DataLog, 102) + ': Erro ao criar Transferncia para filial de qualidade. Referente ao tiket de Troca: ' + @Ticket 
													
													UPDATE dbo.TRANSFERENCIA_FILIAL_QUALIDADE_LOG_B2C
														SET 	OBS					= CONVERT(TEXT, CONVERT(VARCHAR(MAX), OBS) + ' |' + CONVERT(VARCHAR(20), GETDATE(), 103) + ' ' + CONVERT(VARCHAR(20), GETDATE(), 108) + @MsgErro),
																ROMANEIO_SAIDA		= NULL,
																ROMANEIO_ENTRADA	= NULL,
																EMISSAO_ROMANEIO	= NULL,
																RESPONSAVEL			= @Responsavel,
																FILIAL				= NULL,
																FILIAL_DESTINO		= NULL,
																NF_ENTRADA			= NULL,
																SERIE_NF_ENTRADA	= NULL,
																NF_SAIDA			= NULL,
																SERIE_NF_SAIDA		= NULL,
																COMANDO				= @Comando																
														WHERE	CODIGO_FILIAL	= @CodigoFilial
														AND		TICKET			= @Ticket
														AND		DATA_VENDA		= @DataVenda
														AND		OPERACAO		= @Operacao

														GOTO ERROR
												END
										END
	  
				  -- Deleta Romaneio de transferncia
				  /*********************************************************/	
									  IF @Operacao = 'D'
											BEGIN
												SELECT @RomaneioProduto = ROMANEIO_SAIDA, @RomaneioProdutoDestino = ROMANEIO_ENTRADA FROM dbo.TRANSFERENCIA_FILIAL_QUALIDADE_LOG_B2C WHERE OPERACAO = 'I' AND DATA_VENDA = @DataVenda AND CODIGO_FILIAL = @CodigoFilial AND TICKET = @Ticket
												
												IF (@RomaneioProduto IS NOT NULL OR LEN(@RomaneioProduto) > 0) AND EXISTS(SELECT 1 FROM dbo.ESTOQUE_PROD_SAI WHERE ROMANEIO_PRODUTO = @RomaneioProduto AND FILIAL = @FilialOrigem)
													BEGIN
														
														DELETE FROM dbo.ESTOQUE_PROD_SAI WHERE ROMANEIO_PRODUTO = @RomaneioProduto  AND FILIAL= @FilialOrigem 


														IF @@ERROR = 0
															BEGIN
																--Atualiza LOG
																SET @RETORNO = 'Romaneio Sada - ' + @RomaneioProduto + ' | Romaneio Entrada - ' + @RomaneioProdutoDestino + ' apagados com sucesso!'
																
																UPDATE dbo.TRANSFERENCIA_FILIAL_QUALIDADE_LOG_B2C
																SET ROMANEIO_SAIDA		= @RomaneioProduto,
																	EMISSAO_ROMANEIO	= @DataVenda,
																	ROMANEIO_ENTRADA	= @RomaneioProdutoDestino,
																	RESPONSAVEL			= @Responsavel,
																	FILIAL				= @FilialOrigem,
																	FILIAL_DESTINO		= @FilialDestino,
																	NF_ENTRADA			= @Numero_Fiscal_Troca,
																	SERIE_NF_ENTRADA	= @Serie_Nf_Entrada,
																	NF_SAIDA			= @Numero_Fiscal_Venda,
																	SERIE_NF_SAIDA		= @Serie_Nf_Saida,
																	COMANDO				= @Comando,
																	OBS					= @Retorno
																WHERE	CODIGO_FILIAL	= @CodigoFilial
																AND		TICKET			= @Ticket
																AND		DATA_VENDA		= @DataVenda
																AND		OPERACAO		= @Operacao
		
																GOTO RETORNO
															END
														ELSE
															BEGIN
																--Atualiza LOG
																SET @MsgErro = '| ' + CONVERT(VARCHAR(20), @DataLog, 102) + ': Erro ao Deletar Transferncia para filial de qualidade. Referente ao tiket de Troca: ' + @Ticket + ' e Romaneio Sada - ' + @RomaneioProduto  
													
																UPDATE dbo.TRANSFERENCIA_FILIAL_QUALIDADE_LOG_B2C
																	SET 	OBS					= CONVERT(TEXT, CONVERT(VARCHAR(MAX), OBS) + ' |' + CONVERT(VARCHAR(20), GETDATE(), 103) + ' ' + CONVERT(VARCHAR(20), GETDATE(), 108) + @MsgErro),
																			RESPONSAVEL			= @Responsavel,
																			COMANDO				= @Comando																
																	WHERE	CODIGO_FILIAL	= @CodigoFilial
																	AND		TICKET			= @Ticket
																	AND		DATA_VENDA		= @DataVenda
																	AND		OPERACAO		= @Operacao

																	GOTO ERROR
															END

													END
									   END
				END
	END TRY
	
	BEGIN CATCH 
		IF @MsgErro IS NULL
			BEGIN
				SELECT @MsgErro = '| ' + CONVERT(VARCHAR(20), @DataLog, 102) + ': '+ ERROR_MESSAGE()

				UPDATE dbo.TRANSFERENCIA_FILIAL_QUALIDADE_LOG_B2C
				SET 	OBS					= CONVERT(TEXT, CONVERT(VARCHAR(MAX), OBS) + ' |' + CONVERT(VARCHAR(20), GETDATE(), 103) + ' ' + CONVERT(VARCHAR(20), GETDATE(), 108) + @MsgErro),
						RESPONSAVEL			= @Responsavel,
						COMANDO				= @Comando	
				WHERE	CODIGO_FILIAL	= @CodigoFilial
				AND		TICKET			= @Ticket
				AND		DATA_VENDA		= @DataVenda
				AND		OPERACAO		= @Operacao
				
			END
		GOTO ERROR 
	END CATCH 

	
	RETORNO:
		IF @AtivaGeracaoTransf = 1
			BEGIN
				IF @Operacao = 'I'
					BEGIN
						SELECT TRANSACAO = 'Concluda', RETORNO = @Retorno
							
					END
				
				IF @Operacao = 'D'
					BEGIN
						SELECT TRANSACAO = 'Concluda', RETORNO = @Retorno
					END
			END
		RETURN
	
	ERRO_LOG:
			UPDATE dbo.TRANSFERENCIA_FILIAL_QUALIDADE_LOG_B2C
				SET 	OBS					= CONVERT(TEXT, CONVERT(VARCHAR(MAX), OBS) + ' |' + CONVERT(VARCHAR(20), GETDATE(), 103) + ' ' + CONVERT(VARCHAR(20), GETDATE(), 108) + @MsgErro),
						ROMANEIO_SAIDA		= NULL,
						ROMANEIO_ENTRADA	= NULL,
						EMISSAO_ROMANEIO	= NULL,
						RESPONSAVEL			= @Responsavel,
						FILIAL				= NULL,
						FILIAL_DESTINO		= NULL,
						NF_ENTRADA			= NULL,
						SERIE_NF_ENTRADA	= NULL,
						NF_SAIDA			= NULL,
						SERIE_NF_SAIDA		= NULL,
						COMANDO				= @Comando	
				WHERE	CODIGO_FILIAL	= @CodigoFilial
				AND		TICKET			= @Ticket
				AND		DATA_VENDA		= @DataVenda
				AND		OPERACAO		= @Operacao

			GOTO ERROR
	
	ERROR:
		RAISERROR(@MsgErro,16,1) 
END