CREATE PROCEDURE [dbo].[LX_TRACKING] (@PEDIDO INT, @CODIGO_FILIAL_ORIGEM VARCHAR(25) )
AS
--DM85070 - Edson Filenti - Correo no tipo do dado tracking. Necessrio alterao VARCHAR. Correio trabalhando com novo padro.
BEGIN
      DECLARE @FORMA_ENVIO VARCHAR(25), @TRACKING VARCHAR(15), @PREFIXO VARCHAR(5), @SUFIXO VARCHAR(5), @TAMANHO TINYINT, 
            @NUMERO_INICIAL INT, @NUMERO_FINAL INT, @VALOR_ATUAL VARCHAR(15), @VALOR_NOVO INT, @LIMITE NUMERIC(18,2), @ERRO BIT, @MSG VARCHAR(255),
            @RESTO INT, @DIGITO INT, @NUMERO VARCHAR(15), @NUMERO_NOVO VARCHAR(15)
            
      SELECT @ERRO = 0, @MSG = '', @TRACKING = ''
 
      SELECT TOP 1 
            @FORMA_ENVIO = B.FORMA_ENVIO, @PREFIXO = B.PREFIXO_TRACKING, @SUFIXO = B.SUFIXO_TRACKING, @TAMANHO = B.TAMANHO_NUMERO_TRACKING, 
            @VALOR_ATUAL = B.NUMERO_ATUAL_TRACKING, @NUMERO_INICIAL = B.NUMERO_INICIAL_TRACKING, @NUMERO_FINAL = B.NUMERO_FINAL_TRACKING,
            @LIMITE = NUMERO_INICIAL_TRACKING + ((NUMERO_FINAL_TRACKING - (NUMERO_INICIAL_TRACKING - 1)) * (1 - (B.PERCENTUAL_MINIMO/100)))
      FROM 
            LOJA_PEDIDO A 
            INNER JOIN B2C_FORMA_ENVIO B ON A.FORMA_ENVIO = B.FORMA_ENVIO 
      WHERE 
            A.PEDIDO = @PEDIDO AND A.CODIGO_FILIAL_ORIGEM = @CODIGO_FILIAL_ORIGEM 
            AND LEFT(ISNULL(A.TRACKING,''), 2) != B.PREFIXO_TRACKING
            
            
      IF @@ROWCOUNT > 0
      BEGIN 
			SELECT TOP 1 
				@TRACKING = TRACKING
            FROM 
				LOJA_PEDIDO 
			WHERE 
				TRACKING = RTRIM(LTRIM(@PREFIXO)) + RIGHT(RTRIM(LTRIM(REPLICATE('0', @TAMANHO) + RTRIM(LTRIM(CONVERT(VARCHAR, @VALOR_ATUAL + 1))))), @TAMANHO) + RTRIM(LTRIM(@SUFIXO))
				AND CODIGO_FILIAL_ORIGEM = @CODIGO_FILIAL_ORIGEM
				
						
			IF @@ROWCOUNT = 0
			BEGIN 
			
				IF @FORMA_ENVIO != 'TOTAL EXPRESS'
				BEGIN 
					
					SELECT @NUMERO = RIGHT(RTRIM(LTRIM(REPLICATE('0', @TAMANHO) + RTRIM(LTRIM(CONVERT(VARCHAR, @VALOR_ATUAL))))), @TAMANHO)

					SELECT @RESTO = ((LEFT(@NUMERO, 1) * 8) + (CAST(SUBSTRING(@NUMERO, 2, 1) AS INT) * 6) + (CAST(SUBSTRING(@NUMERO, 3, 1) AS INT) * 4) + (CAST(SUBSTRING(@NUMERO, 4, 1) AS INT) * 2) + (CAST(SUBSTRING(@NUMERO, 5, 1) AS INT) * 3) + (CAST(SUBSTRING(@NUMERO, 6, 1) AS INT) * 5) + (CAST(SUBSTRING(@NUMERO, 7, 1) AS INT) * 9) + (CAST(SUBSTRING(@NUMERO, 8, 1) AS INT)* 7))%11
						
					SELECT @DIGITO = CASE WHEN @RESTO = 0 THEN 5 ELSE CASE WHEN @RESTO = 1 THEN 0 ELSE 11 - @RESTO END END 
					
					SELECT @NUMERO_NOVO = LEFT(RIGHT(RTRIM(LTRIM(REPLICATE('0', @TAMANHO) + RTRIM(LTRIM(CONVERT(VARCHAR, @VALOR_ATUAL))))), @TAMANHO), 8) + CAST(@DIGITO AS CHAR(1))
					
					SELECT @TRACKING = RTRIM(LTRIM(@PREFIXO)) + @NUMERO_NOVO + RTRIM(LTRIM(@SUFIXO))
					
				END
				IF @LIMITE > 0
				BEGIN
					IF @VALOR_ATUAL + 1 > @LIMITE
						  SELECT @MSG = 'Limite mnimo de tracking disponveis atingido. Por favor entrar em contato com a transportadora.'
				END
							
				SELECT @VALOR_NOVO = @VALOR_ATUAL + 1
	                        			
				IF @VALOR_NOVO <= @NUMERO_FINAL
				BEGIN
					  IF LEN(RTRIM(LTRIM(ISNULL(@FORMA_ENVIO, '')))) > 0 
					  BEGIN
						IF @TRACKING = ''
							SELECT @TRACKING = RTRIM(LTRIM(@PREFIXO)) + RIGHT(RTRIM(LTRIM(REPLICATE('0', @TAMANHO) + RTRIM(LTRIM(CONVERT(VARCHAR, @VALOR_NOVO))))), @TAMANHO) + RTRIM(LTRIM(@SUFIXO))
												
							--UPDATE B2C_FORMA_ENVIO SET NUMERO_ATUAL_TRACKING = @VALOR_NOVO WHERE FORMA_ENVIO = @FORMA_ENVIO
							UPDATE B2C_FORMA_ENVIO SET NUMERO_ATUAL_TRACKING = RIGHT('000000000000000' + CONVERT(VARCHAR, @VALOR_NOVO), @TAMANHO) WHERE FORMA_ENVIO = @FORMA_ENVIO
							
							UPDATE LOJA_PEDIDO SET TRACKING = @TRACKING WHERE PEDIDO = @PEDIDO AND CODIGO_FILIAL_ORIGEM = @CODIGO_FILIAL_ORIGEM	
					  END
					  ELSE
							SELECT @ERRO = 1, @MSG = 'Forma de envio do pedido est vazia.'
				END
				ELSE
					  SELECT @ERRO = 1, @MSG = 'Tracking no gerado. Quantidade indisponvel, entrar em contato com a transportadora.'
			END
			ELSE
				SELECT @ERRO = 1, @MSG = 'Trancking ' + @TRACKING + ' j foi utilizado.'
      END
      
      SELECT @TRACKING AS TRACKING, @ERRO AS ERRO, @MSG AS MENSAGEM
END




