--05/11/2018 - Wendel Crespigio - Criao da procedure para verificao do Estoque antes do faturamento B2C
CREATE PROCEDURE Lx_verifica_liberacao_estoque_b2c @CODIGO_FILIAL_ORIGEM CHAR(6),@Pedido INT 
AS 
    DECLARE @PERMITE_EST_NEGATIVO BIT, 
            @Produto              CHAR   (12), 
            @Cor                  CHAR   (10), 
            @Tamanho              VARCHAR(5), 
            @Estoque              VARCHAR(10), 
            @Tamanho_Estoque      VARCHAR(5), 
            @NOME_FILIAL          VARCHAR(100), 
            @sqlSELECT            VARCHAR(300),
			@QTDE                 int;
			
			Declare @TABLE_ESTOQUE TABLE ( Estoque INT ) ;

    SELECT @PERMITE_EST_NEGATIVO = permite_est_negativo,@NOME_FILIAL = filial 
    FROM   filiais 
    WHERE  cod_filial = @CODIGO_FILIAL_ORIGEM 

    -- Verifica parametros do estoque na tabelas Filiais  
    IF @PERMITE_EST_NEGATIVO = 1 
      BEGIN 
          RETURN; 
      END 

    SELECT * 
    INTO   #pedido_b2c 
    FROM   loja_pedido_produto 
    WHERE  pedido = @Pedido 
           AND codigo_filial_origem = @CODIGO_FILIAL_ORIGEM; 

    SELECT TOP 1 @Produto = produto, 
                 @Cor     = cor_produto, @Tamanho = tamanho, @QTDE = QTDE 
    FROM   #pedido_b2c; 

    WHILE @@rowcount <> 0 
      BEGIN 
          SET @Tamanho_Estoque = 'ES' + CONVERT(VARCHAR, @Tamanho) 
          SET @sqlSELECT= 'select ' + @Tamanho_Estoque 
                          + ' from dbo.Estoque_produtos where produto = ' 
                          + '''' + Rtrim(Ltrim( @Produto )) + '''' 
                          + ' and COR_PRODUTO =' + '''' 
                          + Rtrim(Ltrim( @Cor )) + '''' + ' AND FILIAL = ' 
                          + '''' + Rtrim(Ltrim( @NOME_FILIAL)) + '''' 

          INSERT INTO @TABLE_ESTOQUE 
          EXECUTE(@sqlSELECT); 

          SELECT @estoque = estoque FROM @TABLE_ESTOQUE; 

          IF (@estoque <= 0 or @estoque < @QTDE)
            BEGIN 
                SELECT @Produto AS PRODUTO, @Cor AS COR_PRODUTO ;
				RETURN 
            END 

          DELETE #pedido_b2c WHERE  produto = @Produto AND cor_produto = @Cor AND tamanho = @Tamanho and QTDE = @QTDE
		  DELETE @TABLE_ESTOQUE 

          SELECT TOP 1 @Produto = produto, @Cor = cor_produto, @Tamanho = tamanho , @QTDE = QTDE FROM #pedido_b2c 
      END 
    DROP TABLE #pedido_b2c 