ALTER PROCEDURE [dbo].[LX_VERIFICA_LIBERACAO_FATURAMENTO_B2C] (@CODIGO_FILIAL CHAR(6), @PEDIDO INT)  
		AS
		BEGIN

		--27/08/2019 - EDSON FILENTI  - MODASP-5134	- #3# - Incluso da forma '>' Vale Omni e tratamento para NUMERO_TITULO aceitar VARCHAR.
		--07/06/2019 - EDSON FILENTI  - MODASP-2551	- #2# - Para pedidos com mais de uma forma de PGTO  necessrio validar a existncia de algum pedido com Captura = 0. Caso exista o pedido no est liberado para faturamento.
		--08/03/2019 - EDSON FILENTI  - DM 111584   - #1# - Controle para liberar apenas pedidos possveis de faturamento
		
			--#2#
					SELECT
						CONVERT(BIT, 1)         
					FROM    
						LOJA_PEDIDO AS A         
						
						INNER JOIN (
									SELECT 
											CODIGO_FILIAL_ORIGEM		AS CODIGO_FILIAL_ORIGEM, 
											PEDIDO						AS PEDIDO, 
											SUM(QTDE)					AS QTDE, 
											SUM(QTDE_VENDA)				AS QTDE_VENDA, 
											SUM(QTDE * PRECO_LIQUIDO)	AS VALOR_TOTAL
									FROM  
										dbo.LOJA_PEDIDO_PRODUTO        
									GROUP BY 
										CODIGO_FILIAL_ORIGEM, PEDIDO  
						) AS B ON A.CODIGO_FILIAL_ORIGEM = B.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = B.PEDIDO  

						--#2# Seleo para validar pgtos sem confirmao
						LEFT OUTER JOIN (
										SELECT 
												CODIGO_FILIAL_ORIGEM									AS CODIGO_FILIAL_ORIGEM, 
												PEDIDO													AS PEDIDO, 
												CONVERT(BIT, MIN(CONVERT(INT, ISNULL(CAPTURADO, 0))))	AS CAPTURADO        
										FROM 
											dbo.LOJA_PEDIDO_PGTO       
										WHERE 
											TIPO_PGTO NOT IN ('L', 'R', 'T', '&', '>') --#3#
										AND (CAPTURADO = 0 OR CAPTURADO IS NULL)
										GROUP BY 
											CODIGO_FILIAL_ORIGEM, PEDIDO, CAPTURADO    
						) AS PagPend ON A.CODIGO_FILIAL_ORIGEM = PagPend.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = PagPend.PEDIDO   

							        
						LEFT OUTER JOIN (
										SELECT	
												CODIGO_FILIAL_ORIGEM									AS CODIGO_FILIAL_ORIGEM, 
												PEDIDO													AS PEDIDO, 
												MIN(ISNULL(NUMERO_APROVACAO_CARTAO, ''))				AS NUMERO_APROVACAO_CARTAO, 
												TIPO_PGTO												AS TIPO_PGTO,        
												MIN(ISNULL(NUMERO_TITULO, ''))							AS NUMERO_TITULO, 
												CONVERT(BIT, MIN(CONVERT(INT, ISNULL(CAPTURADO, 0))))	AS CAPTURADO        
										FROM 
											dbo.LOJA_PEDIDO_PGTO       
										WHERE 
											TIPO_PGTO NOT IN ('L', 'R', 'T', '&', '>')  --#3#
										GROUP BY 
											CODIGO_FILIAL_ORIGEM, PEDIDO, TIPO_PGTO  
											
						) AS C ON A.CODIGO_FILIAL_ORIGEM = C.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = C.PEDIDO        
						
						
						LEFT JOIN (
									SELECT
										CODIGO_FILIAL_ORIGEM, 
										PEDIDO, MIN(ISNULL(NUMERO_APROVACAO_CARTAO, ''))		AS NUMERO_APROVACAO_CARTAO, 
										MIN(ISNULL(NUMERO_TITULO, ''))							AS NUMERO_TITULO, 
										CONVERT(BIT, MIN(CONVERT(INT, ISNULL(CAPTURADO, 0))))	AS CAPTURADO, 
										TIPO_PGTO, min(isnull(VENCIMENTO, ''))					AS VENCIMENTO
									FROM
										DBO.LOJA_PEDIDO_PGTO
									WHERE 
										TIPO_PGTO in('R', '>') --#3#
									AND VALOR > 0
									GROUP BY
											CODIGO_FILIAL_ORIGEM, PEDIDO, TIPO_PGTO
						) D ON A.CODIGO_FILIAL_ORIGEM = D.CODIGO_FILIAL_ORIGEM AND A.PEDIDO = D.PEDIDO	
															 
					 WHERE   
							CONVERT(BIT, CASE WHEN A.CANCELADO = 0 AND A.ENTREGUE = 0 AND B.QTDE = 0  THEN 1 ELSE 0 END) = 0 
						AND CONVERT(BIT, 
										CASE	WHEN ISNULL(B2C_LOJA,0) = 0
												THEN 
													CASE	WHEN( CASE WHEN ISNULL(C.TIPO_PGTO, '') != '' 
															THEN (ISNULL(C.NUMERO_APROVACAO_CARTAO, '')) 
													ELSE ISNULL(D.NUMERO_APROVACAO_CARTAO, '') 
													END <> '' 
												AND	CASE	WHEN ISNULL(C.TIPO_PGTO, '') != '' 
															THEN ISNULL(PagPend.CAPTURADO, 0) 
													ELSE ISNULL(D.CAPTURADO, 0) 
													END = 1)  
												OR (( CASE	WHEN ISNULL(C.TIPO_PGTO, '') != '' 
															THEN  C.NUMERO_TITULO --#3# 
													  ELSE D.NUMERO_TITULO --#3# 
													  END) > '0' --#3#
													  AND CASE	WHEN ISNULL(C.TIPO_PGTO, '') != '' 
																THEN ISNULL(PagPend.CAPTURADO, 1) ELSE ISNULL(D.CAPTURADO, 0) --#2#
																END = 1) 
												OR (( CASE	WHEN ISNULL(C.TIPO_PGTO, '') != '' 
															THEN C.NUMERO_TITULO --#3# 
													  ELSE D.NUMERO_TITULO		 --#3#
													  END = 0 
    												  AND  CASE WHEN ISNULL(C.TIPO_PGTO, '') != '' 
																THEN ISNULL(C.NUMERO_APROVACAO_CARTAO, '') 
																ELSE ISNULL(D.NUMERO_APROVACAO_CARTAO, '') 
															END = '' )
												AND CASE	WHEN ISNULL(C.TIPO_PGTO, '') != '' 
															THEN ISNULL(C.PEDIDO, '') 
													ELSE ISNULL(D.PEDIDO, '') 
													END  > 0 ) 
											THEN 1 
											ELSE 0 END
							ELSE
								CASE	WHEN ISNULL(C.PEDIDO, '') > 0  
										THEN 1 
								ELSE 0 END 
						END) = 1        
						AND DIGITACAO_ENCERRADA = 1 
						AND CANCELADO = 0   
						AND B.QTDE_VENDA <  B.QTDE    
						AND A.PEDIDO = @PEDIDO 
						AND A.CODIGO_FILIAL_ORIGEM = @CODIGO_FILIAL
						AND A.TIPO_PEDIDO IN (4, 5, 6, 7)	-- Incluso do pedido TRIANGULAR
						AND A.STATUS_B2C IN (0, 1, 2, 3, 9) --#1# Controle para liberao de pedidos
					GROUP BY A.CODIGO_FILIAL_ORIGEM,  A.PEDIDO -- #2#
	END
GO


