
-- B2C_FORMA_ENVIO
IF EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'B2C_FORMA_ENVIO' AND TABLE_SCHEMA = 'DBO')
	BEGIN 
		EXEC sp_unbindefault 'B2C_FORMA_ENVIO.NUMERO_INICIAL_TRACKING' ; 
			ALTER TABLE B2C_FORMA_ENVIO ALTER COLUMN NUMERO_INICIAL_TRACKING VARCHAR(15);
		EXEC sp_bindefault 'DEFAULT_0','B2C_FORMA_ENVIO.NUMERO_INICIAL_TRACKING';  

		EXEC sp_unbindefault 'B2C_FORMA_ENVIO.NUMERO_FINAL_TRACKING' 
			ALTER TABLE B2C_FORMA_ENVIO ALTER COLUMN NUMERO_FINAL_TRACKING   VARCHAR(15);
		EXEC sp_bindefault 'DEFAULT_0','B2C_FORMA_ENVIO.NUMERO_FINAL_TRACKING';  

		EXEC sp_unbindefault 'B2C_FORMA_ENVIO.NUMERO_ATUAL_TRACKING';
			ALTER TABLE B2C_FORMA_ENVIO ALTER COLUMN NUMERO_ATUAL_TRACKING   VARCHAR(15);
		EXEC sp_bindefault 'DEFAULT_0','B2C_FORMA_ENVIO.NUMERO_ATUAL_TRACKING'; 
	END
ELSE
	BEGIN 
		CREATE TABLE [dbo].[B2C_FORMA_ENVIO](
												[FORMA_ENVIO]				[varchar](25)		NOT NULL,
												[NUMERO_CONTRATO]			[varchar](25)		NULL,
												[LAYOUT_ETIQUETA]			[varchar](200)		NULL,
												[PREFIXO_TRACKING]			[varchar](5)		NULL,
												[SUFIXO_TRACKING]			[varchar](5)		NULL,
												[NUMERO_INICIAL_TRACKING]	[varchar](8)		NULL,
												[NUMERO_FINAL_TRACKING]		[varchar](8)		NULL,
												[NUMERO_ATUAL_TRACKING]		[varchar](8)		NULL,
												[TAMANHO_NUMERO_TRACKING]	[tinyint]			NULL,
												[URL_TRANSPORTADORA]		[varchar](200)		NULL,
												[COD_SERVICO_CORREIO]		[varchar](10)		NULL,
												[PERCENTUAL_MINIMO]			[numeric](18, 2)	NULL,
											 CONSTRAINT [XPKB2C_FORMA_ENVIO] PRIMARY KEY NONCLUSTERED 
											(
												[FORMA_ENVIO] ASC
											)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
											) ON [PRIMARY]

	END

GO

IF EXISTS (SELECT 1 FROM sys.OBJECTS where name = 'B2C_FORMA_ENVIO' )
		PRINT '<<<< Tabela B2C_FORMA_ENVIO atualizada com sucesso. >>>>'
ELSE
		PRINT '<<<< No foi possvel atualizar a Procedure B2C_FORMA_ENVIO. Verifique!  >>>>'

GO
