
-- Issue https://jira.linx.com.br/browse/INTEGSP-1807


CREATE TABLE dbo.TIPOS_RUPTURA_B2C(
								[ID_RUPTURA]			SMALLINT NOT NULL,
								[MOTIVO_RUPTURA]	VARCHAR(100) NOT NULL
CONSTRAINT [XPKTIPOS_RUPTURA_B2C] PRIMARY KEY CLUSTERED 
							(
								[ID_RUPTURA] ASC
							)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] 


GO


CREATE TABLE [dbo].[LOJA_PEDIDO_RUPTURA_B2C](
			[ID]						[int] IDENTITY(1,1) NOT NULL,
			[PEDIDO]					[int]			NOT NULL,
			[CODIGO_FILIAL_ORIGEM]		[char](6)		NOT NULL,
			[DATA_RUPTURA]				[smalldatetime] NULL,
			[ITEM_PEDIDO]				[int]			NOT NULL,
			[PRODUTO]					[char](12)		NULL,
			[COR_PRODUTO]				[char](10)		NULL,
			[TAMANHO]					[smallint]		NULL,
			[CODIGO_BARRA]				[varchar](25)	NOT NULL,
			[QTDE]						[int]			NULL,
			[CANCELADO]					[bit]			NULL DEFAULT 0,
			[ID_RUPTURA]				[SMALLINT]		NOT NULL,
			[OBS]						[text]			NULL,
			[DATA_PARA_TRANSFERENCIA]	[datetime]		NULL,
			[USUARIO]					[varchar](25)	NULL
CONSTRAINT [XPKLOJA_PEDIDO_RUPTURA_B2C] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
ALTER TABLE [dbo].[LOJA_PEDIDO_RUPTURA_B2C]  WITH NOCHECK ADD CONSTRAINT [XFK13699_LOJA_PEDIDO_RUPTURA_B2C] FOREIGN KEY([PEDIDO], [CODIGO_FILIAL_ORIGEM])
REFERENCES [dbo].[LOJA_PEDIDO] ([PEDIDO], [CODIGO_FILIAL_ORIGEM])
	ON UPDATE CASCADE
	ON DELETE CASCADE
	NOT FOR REPLICATION 
GO
	ALTER TABLE [dbo].[LOJA_PEDIDO_RUPTURA_B2C] CHECK CONSTRAINT [XFK13699_LOJA_PEDIDO_RUPTURA_B2C]
GO
	ALTER TABLE [dbo].[LOJA_PEDIDO_RUPTURA_B2C]  WITH NOCHECK ADD  CONSTRAINT [XFK13708_LOJA_PEDIDO_RUPTURA_B2C] FOREIGN KEY([PRODUTO], [COR_PRODUTO])
	REFERENCES [dbo].[PRODUTO_CORES] ([PRODUTO], [COR_PRODUTO])
	NOT FOR REPLICATION 
GO
	ALTER TABLE [dbo].[LOJA_PEDIDO_RUPTURA_B2C] CHECK CONSTRAINT [XFK13708_LOJA_PEDIDO_RUPTURA_B2C]
GO


-- triggers

--Update
create trigger [dbo].[LXU_LOJA_PEDIDO_RUPTURA_B2C] on [dbo].[LOJA_PEDIDO_RUPTURA_B2C] for UPDATE NOT FOR REPLICATION as
				/* UPDATE trigger on LOJA_PEDIDO_RUPTURA_B2C */
				begin
				  declare  @numrows int,
						   @nullcnt int,
						   @validcnt int,
						   @insCODIGO_FILIAL_ORIGEM char(6), 
						   @insPEDIDO int, 
						   @insITEM int,
						   @delCODIGO_FILIAL_ORIGEM char(6), 
						   @delPEDIDO int, 
						   @delITEM int,
						   @errno   int,
						   @errmsg  varchar(255)

				  select @numrows = @@rowcount

				 /* LOJA_PEDIDO R/2554 LOJA_PEDIDO_RUPTURA_B2C ON CHILD UPDATE RESTRICT */
				  if
					update(CODIGO_FILIAL_ORIGEM) or
					update(PEDIDO)
				  begin
					select @nullcnt = 0
					select @validcnt = count(*)
					  from inserted,LOJA_PEDIDO
					 where
						   inserted.CODIGO_FILIAL_ORIGEM = LOJA_PEDIDO.CODIGO_FILIAL_ORIGEM and
						   inserted.PEDIDO = LOJA_PEDIDO.PEDIDO
    
					if @validcnt + @nullcnt != @numrows
					begin
					  select @errno  = 30007,
							 @errmsg = 'Impossvel Atualizar  #LOJA_PEDIDO_RUPTURA_B2C #porque #LOJA_PEDIDO #no existe.'
					  goto error
					end
				  end

				  /* PRODUTO_CORES R/2568 LOJA_PEDIDO_RUPTURA_B2C ON CHILD UPDATE RESTRICT */
				  if
					update(PRODUTO) or
					update(COR_PRODUTO)
				  begin
					select @nullcnt = 0
					select @validcnt = count(*)
					  from inserted,PRODUTO_CORES
					 where
						   inserted.PRODUTO = PRODUTO_CORES.PRODUTO and
						   inserted.COR_PRODUTO = PRODUTO_CORES.COR_PRODUTO
					select @nullcnt = count(*) from inserted where
					  inserted.PRODUTO is null and
					  inserted.COR_PRODUTO is null
					if @validcnt + @nullcnt != @numrows
					begin
					  select @errno  = 30007,
							 @errmsg = 'Impossvel Atualizar  #LOJA_PEDIDO_RUPTURA_B2C #porque #PRODUTO_CORES #no existe.'
					  goto error
					end
				  end

				/*---LINX-UPDATE---------------------------------------------------------------------------------------*/

				IF NOT UPDATE(DATA_PARA_TRANSFERENCIA)
				BEGIN
					UPDATE 	LOJA_PEDIDO_RUPTURA_B2C 
					SET 	DATA_PARA_TRANSFERENCIA = GETDATE(),
							USUARIO					= SYSTEM_USER 
					FROM 	LOJA_PEDIDO_RUPTURA_B2C, INSERTED
					WHERE 	LOJA_PEDIDO_RUPTURA_B2C.CODIGO_FILIAL_ORIGEM = INSERTED.CODIGO_FILIAL_ORIGEM and
						LOJA_PEDIDO_RUPTURA_B2C.PEDIDO = INSERTED.PEDIDO and
						LOJA_PEDIDO_RUPTURA_B2C.ITEM_PEDIDO = INSERTED.ITEM_PEDIDO 
						AND (INSERTED.DATA_PARA_TRANSFERENCIA IS NULL 
						OR LOJA_PEDIDO_RUPTURA_B2C.DATA_PARA_TRANSFERENCIA = INSERTED.DATA_PARA_TRANSFERENCIA)
				END
				/*-----------------------------------------------------------------------------------------------------*/

				  return
				error:
					raiserror(@errmsg, 18, 1)
					rollback transaction
				end

GO

ALTER TABLE [dbo].[LOJA_PEDIDO_RUPTURA_B2C] ENABLE TRIGGER [LXU_LOJA_PEDIDO_RUPTURA_B2C]
GO


-- TRIGGER DELETE

create trigger [dbo].[LXD_LOJA_PEDIDO_RUPTURA_B2C] on [dbo].[LOJA_PEDIDO_RUPTURA_B2C] for delete not for replication as
/* INSERT trigger on LOJA_PEDIDO_PRODUTO */
begin
  declare  @numrows int,
           @nullcnt int,
           @validcnt int,
           @delCODIGO_FILIAL_ORIGEM char(6), 
           @delPEDIDO int, 
           @delITEM int,
           @errno   int,
           @errmsg  varchar(255)

  select @numrows = @@rowcount

	/* LOJA_PEDIDO_SAIDA LOJA_PEDIDO ON PARENT DELETE RESTRICT */
	if exists (SELECT * FROM DELETED, LOJA_PEDIDO_PRODUTO 
		WHERE LOJA_PEDIDO_PRODUTO.CODIGO_FILIAL_ORIGEM = DELETED.CODIGO_FILIAL_ORIGEM 
		AND LOJA_PEDIDO_PRODUTO.PEDIDO = DELETED.PEDIDO 
		AND LOJA_PEDIDO_PRODUTO.ITEM = DELETED.ITEM_PEDIDO)
	begin
		select @errno  = 30001,
			@errmsg = 'Impossvel excluir #LOJA_PEDIDO_RUPTURA_B2C #porque existem registros em #LOJA_PEDIDO_PRODUTO.'
      		goto error
	end

	/* LOJA_PEDIDO_VENDA LOJA_PEDIDO ON PARENT DELETE RESTRICT */
	if exists (SELECT * FROM DELETED, LOJA_PEDIDO_VENDA 
		WHERE LOJA_PEDIDO_VENDA.CODIGO_FILIAL_ORIGEM = DELETED.CODIGO_FILIAL_ORIGEM 
		AND LOJA_PEDIDO_VENDA.PEDIDO = DELETED.PEDIDO 
		AND LOJA_PEDIDO_VENDA.ITEM = DELETED.ITEM_PEDIDO)
	begin
		select @errno  = 30001,
			@errmsg = 'Impossvel excluir #LOJA_PEDIDO_RUPTURA_B2C #porque existem registros em #LOJA_PEDIDO_VENDA.'
      		goto error
	end

  return
error:
    raiserror(@errmsg, 18, 1)
    rollback transaction
end

GO

ALTER TABLE [dbo].[LOJA_PEDIDO_RUPTURA_B2C] ENABLE TRIGGER [LXD_LOJA_PEDIDO_RUPTURA_B2C]
GO


-- TRIGGER INSERT

create  trigger [dbo].[LXI_LOJA_PEDIDO_RUPTURA_B2C] 
on [dbo].[LOJA_PEDIDO_RUPTURA_B2C]
  for INSERT NOT FOR REPLICATION
  as
begin
  declare  @numrows int,
           @nullcnt int,
           @validcnt int,
           @insCODIGO_FILIAL char(6), 
           @insTICKET char(8), 
           @insDATA_VENDA datetime,
           @errno   int,
           @errmsg  varchar(255)

  select @numrows = @@rowcount

/*---LINX-INSERT---------------------------------------------------------------------------------------*/
	UPDATE 	LOJA_PEDIDO_RUPTURA_B2C 
	SET 	DATA_PARA_TRANSFERENCIA = GETDATE(),
			USUARIO					= SYSTEM_USER 
	FROM 	LOJA_PEDIDO_RUPTURA_B2C, INSERTED
	WHERE 	LOJA_PEDIDO_RUPTURA_B2C.CODIGO_FILIAL_ORIGEM	= INSERTED.CODIGO_FILIAL_ORIGEM and
			LOJA_PEDIDO_RUPTURA_B2C.PEDIDO					= INSERTED.PEDIDO and
			LOJA_PEDIDO_RUPTURA_B2C.ITEM_PEDIDO				= INSERTED.ITEM_PEDIDO AND 
			(	INSERTED.DATA_PARA_TRANSFERENCIA IS NULL 
				OR 
				LOJA_PEDIDO_RUPTURA_B2C.DATA_PARA_TRANSFERENCIA = INSERTED.DATA_PARA_TRANSFERENCIA
			)
/*-----------------------------------------------------------------------------------------------------*/
  return
error:
    raiserror (@errmsg, 16, 1)
    rollback transaction
end

GO

ALTER TABLE [dbo].[LOJA_PEDIDO_RUPTURA_B2C] ENABLE TRIGGER [LXI_LOJA_PEDIDO_RUPTURA_B2C]
GO


